<?php
require_once __DIR__ . '/../../src/config.php';
require_once __DIR__ . '/../../src/csrf.php';
require_once __DIR__ . '/../../src/layout.php';
require_login();
$user = current_user();
if ($user['user_type'] !== 'admin') { http_response_code(403); echo 'Forbidden'; exit; }
$pdo = db();
$errors=[];$success='';
$showDeleted = (int)($_GET['showDeleted'] ?? 0);
if($_SERVER['REQUEST_METHOD']==='POST') {
    if(!csrf_verify()) { $errors[]='Bad CSRF'; }
    else {
        if(isset($_POST['bulk_delete'])) {
            $ids = $_POST['bulk_ids'] ?? [];
            if (!is_array($ids) || empty($ids)) {
                $errors[] = 'No students selected for bulk delete.';
            } else {
                $deletedCount = 0;
                $delStmt = $pdo->prepare('UPDATE preapproved_students SET is_deleted=1 WHERE student_id=?');
                $logStmt = $pdo->prepare('INSERT INTO audit_logs (user_id,action,details) VALUES (?,?,?)');
                foreach ($ids as $bid) {
                    $bidTrim = trim($bid);
                    if ($bidTrim === '') continue;
                    $delStmt->execute([$bidTrim]);
                    $logStmt->execute([$user['id'],'bulk_delete_preapproved',json_encode(['student_id'=>$bidTrim])]);
                    $deletedCount++;
                }
                $success = 'Bulk deleted ' . $deletedCount . ' students.';
            }
        }
        if(isset($_POST['bulk_restore'])) {
            $ids = $_POST['bulk_ids'] ?? [];
            if (!is_array($ids) || empty($ids)) {
                $errors[] = 'No students selected for bulk restore.';
            } else {
                $restoredCount = 0;
                $resStmt = $pdo->prepare('UPDATE preapproved_students SET is_deleted=0 WHERE student_id=?');
                $logStmt = $pdo->prepare('INSERT INTO audit_logs (user_id,action,details) VALUES (?,?,?)');
                foreach ($ids as $bid) {
                    $bidTrim = trim($bid);
                    if ($bidTrim === '') continue;
                    $resStmt->execute([$bidTrim]);
                    $logStmt->execute([$user['id'],'bulk_restore_preapproved',json_encode(['student_id'=>$bidTrim])]);
                    $restoredCount++;
                }
                $success = 'Bulk restored ' . $restoredCount . ' students.';
            }
        }
        if(isset($_POST['add_student'])) {
            $sid=trim($_POST['student_id']??'');
            $sname=trim($_POST['student_name']??'');
            if($sid==='') $errors[]='Student ID required';
            else {
                try {
                    $stmt=$pdo->prepare('INSERT INTO preapproved_students (student_id,name) VALUES (?,?)');
                    $stmt->execute([$sid,$sname]);
                    $log=$pdo->prepare('INSERT INTO audit_logs (user_id,action,details) VALUES (?,?,?)');
                    $log->execute([$user['id'],'add_preapproved',json_encode(['student_id'=>$sid])]);
                    $success='Preapproved student added.';
                } catch(Exception $e){ $errors[]='Add failed: '.$e->getMessage(); }
            }
        }
        if(isset($_POST['delete_student'])) {
            $sid=trim($_POST['student_id']??'');
            if($sid==='') { $sid = trim($_POST['delete_student']); }
            if($sid!=='') {
                $del=$pdo->prepare('UPDATE preapproved_students SET is_deleted=1 WHERE student_id=?');
                $del->execute([$sid]);
                $log=$pdo->prepare('INSERT INTO audit_logs (user_id,action,details) VALUES (?,?,?)');
                $log->execute([$user['id'],'delete_preapproved',json_encode(['student_id'=>$sid])]);
                $success='Preapproved student deleted.';
            }
        }
        if(isset($_POST['restore_student'])) {
            $sid=trim($_POST['restore_student']);
            if($sid!=='') {
                $res=$pdo->prepare('UPDATE preapproved_students SET is_deleted=0 WHERE student_id=?');
                $res->execute([$sid]);
                $log=$pdo->prepare('INSERT INTO audit_logs (user_id,action,details) VALUES (?,?,?)');
                $log->execute([$user['id'],'restore_preapproved',json_encode(['student_id'=>$sid])]);
                $success='Preapproved student restored.';
            }
        }
    }
}
// Pagination & search
$search = trim($_GET['q'] ?? '');
$page = max(1, (int)($_GET['page'] ?? 1));
$allowedPerPage = [25,50,100];
$perPage = (int)($_GET['perPage'] ?? ($_SESSION['admin_perPage'] ?? 25));
if (!in_array($perPage, $allowedPerPage, true)) { $perPage = 25; }
// Sorting
$allowedSort = ['student_id','name','created_at'];
$sort = $_GET['sort'] ?? ($_SESSION['admin_sort'] ?? 'created_at');
if (!in_array($sort, $allowedSort, true)) { $sort = 'created_at'; }
$dir = strtolower($_GET['dir'] ?? ($_SESSION['admin_dir'] ?? 'desc'));
if (!in_array($dir, ['asc','desc'], true)) { $dir = 'desc'; }
$sortLabel = ucfirst(str_replace('_', ' ', $sort));
$dirReadable = $dir === 'asc' ? 'ascending' : 'descending';

// Persist user preferences in session
$_SESSION['admin_perPage'] = $perPage;
$_SESSION['admin_sort'] = $sort;
$_SESSION['admin_dir'] = $dir;

// Dynamic conditions
$conditions = [];
$params = [];
if ($search !== '') {
    $conditions[] = '(student_id LIKE ? OR name LIKE ?)';
    $like = '%' . $search . '%';
    $params[] = $like; $params[] = $like;
}
if (!$showDeleted) {
    $conditions[] = 'is_deleted=0';
}
$where = $conditions ? ('WHERE ' . implode(' AND ', $conditions)) : '';

// Count total (respecting filter of deleted if not showing them)
$countSql = "SELECT COUNT(*) FROM preapproved_students $where";
$countStmt = $pdo->prepare($countSql);
$countStmt->execute($params);
$total = (int)$countStmt->fetchColumn();
$totalPages = max(1, (int)ceil($total / $perPage));
if ($page > $totalPages) { $page = $totalPages; }
$offset = ($page - 1) * $perPage;

// Fetch page
$orderClause = "$sort $dir, student_id ASC"; // secondary deterministic sort
$sql = "SELECT student_id,name,created_at,is_deleted FROM preapproved_students $where ORDER BY $orderClause LIMIT $offset,$perPage";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$students = $stmt->fetchAll();
require_once __DIR__ . '/../../src/layout.php';
render_header('Preapproved Students', [], $user);
?>
<section class="mb-4">
    <div class="row g-3">
        <div class="col-md-4">
            <div class="app-card p-4">
                <p class="text-uppercase small text-muted mb-1">Total approved</p>
                <h3 class="mb-0"><?= $total ?></h3>
                <p class="muted small mb-0">Students in your import</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="app-card p-4">
                <p class="text-uppercase small text-muted mb-1">Page size</p>
                <h3 class="mb-0"><?= $perPage ?></h3>
                <p class="muted small mb-0">Rows per view</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="app-card p-4">
                <p class="text-uppercase small text-muted mb-1">Deleted filter</p>
                <h3 class="mb-0"><?= $showDeleted ? 'On' : 'Off' ?></h3>
                <p class="muted small mb-0">Toggle to review archived</p>
            </div>
        </div>
    </div>
</section>

<section class="app-card p-4 mb-4">
    <form method="get" class="row g-3 align-items-end" aria-label="Search preapproved students">
        <div class="col-sm-6 col-lg-3">
            <label class="form-label small text-uppercase">Search</label>
            <input type="text" class="form-control" name="q" value="<?= htmlspecialchars($search) ?>" placeholder="ID or Name">
        </div>
        <div class="col-sm-6 col-lg-3">
            <label class="form-label small text-uppercase">Per page</label>
            <select class="form-select" name="perPage"><?php foreach($allowedPerPage as $pp): ?><option value="<?= $pp ?>" <?= $pp===$perPage?'selected':'' ?>><?= $pp ?></option><?php endforeach; ?></select>
        </div>
        <div class="col-sm-6 col-lg-2">
            <label class="form-label small text-uppercase">Sort by</label>
            <select class="form-select" name="sort"><?php foreach($allowedSort as $sKey): ?><option value="<?= $sKey ?>" <?= $sKey===$sort?'selected':'' ?>><?= $sKey ?></option><?php endforeach; ?></select>
        </div>
        <div class="col-sm-6 col-lg-2">
            <label class="form-label small text-uppercase">Direction</label>
            <select class="form-select" name="dir"><option value="asc" <?= $dir==='asc'?'selected':'' ?>>Asc</option><option value="desc" <?= $dir==='desc'?'selected':'' ?>>Desc</option></select>
        </div>
        <div class="col-sm-6 col-lg-2">
            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="showDeleted" value="1" id="toggleDeleted" <?= $showDeleted? 'checked':'' ?> onchange="this.form.submit()">
                <label class="form-check-label" for="toggleDeleted">Show deleted</label>
            </div>
        </div>
        <div class="col-12 d-flex gap-2">
            <button type="submit" class="btn btn-primary">Apply</button>
            <?php if($search): ?><a class="btn btn-outline-secondary" href="/admin/index.php">Clear</a><?php endif; ?>
            <a class="btn btn-outline-primary" href="/admin/import.php">Bulk Import</a>
            <a class="btn btn-outline-primary" href="/admin/export_preapproved.php?q=<?= urlencode($search) ?>&perPage=<?= $perPage ?>&sort=<?= urlencode($sort) ?>&dir=<?= urlencode($dir) ?>" target="_blank" rel="noreferrer" aria-label="Export filtered preapproved students to CSV (opens in new tab)">Export CSV</a>
            <a class="btn btn-outline-primary" href="/admin/teachers.php">Teachers</a>
            <a class="btn btn-outline-primary" href="/admin/logs.php">Audit Logs</a>
        </div>
    </form>
</section>

<section class="app-card p-4 mb-4">
    <?php foreach($errors as $e): ?><div class="alert alert-danger" role="alert" aria-live="assertive"><?= htmlspecialchars($e) ?></div><?php endforeach; ?>
    <?php if($success): ?><div class="alert alert-success" role="status" aria-live="polite"><?= htmlspecialchars($success) ?></div><?php endif; ?>
    <form method="post" id="bulkForm">
        <?= csrf_field(); ?>
        <p id="preapproved-table-help" class="visually-hidden">Use the first column checkboxes to select students for bulk delete or restore actions.</p>
        <div class="data-table table-responsive" role="region" aria-labelledby="preapproved-table-caption">
            <table class="table align-middle mb-0" aria-labelledby="preapproved-table-caption" aria-describedby="preapproved-table-help">
                <caption id="preapproved-table-caption" class="visually-hidden">Preapproved students sorted by <?= htmlspecialchars($sortLabel) ?> in <?= $dirReadable ?> order.</caption>
                <thead>
                    <tr>
                        <th scope="col">
                            <span class="visually-hidden">Select row</span>
                            <input aria-label="Select all" type="checkbox" onclick="toggleAll(this)">
                        </th>
                        <th scope="col" aria-sort="<?= $sort === 'student_id' ? $dirReadable : 'none' ?>">
                            ID
                            <a class="code" aria-label="Change sort for ID" href="?q=<?= urlencode($search) ?>&perPage=<?= $perPage ?>&sort=student_id&dir=<?= $sort==='student_id' && $dir==='asc'?'desc':'asc' ?>">↕</a>
                        </th>
                        <th scope="col" aria-sort="<?= $sort === 'name' ? $dirReadable : 'none' ?>">
                            Name
                            <a class="code" aria-label="Change sort for Name" href="?q=<?= urlencode($search) ?>&perPage=<?= $perPage ?>&sort=name&dir=<?= $sort==='name' && $dir==='asc'?'desc':'asc' ?>">↕</a>
                        </th>
                        <th scope="col" aria-sort="<?= $sort === 'created_at' ? $dirReadable : 'none' ?>">
                            Added
                            <a class="code" aria-label="Change sort for Added date" href="?q=<?= urlencode($search) ?>&perPage=<?= $perPage ?>&sort=created_at&dir=<?= $sort==='created_at' && $dir==='asc'?'desc':'asc' ?>">↕</a>
                        </th>
                        <th scope="col">Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach($students as $s): ?>
                    <tr class="<?= $s['is_deleted']? 'table-danger':'' ?>">
                        <td><input type="checkbox" name="bulk_ids[]" value="<?= htmlspecialchars($s['student_id']) ?>"></td>
                        <td><?= htmlspecialchars($s['student_id']) ?></td>
                        <td><?= htmlspecialchars($s['name']) ?></td>
                        <td><?= htmlspecialchars($s['created_at']) ?></td>
                        <td class="d-flex flex-wrap gap-2">
                            <a class="btn btn-sm btn-outline-primary" href="/admin/edit_student.php?student_id=<?= urlencode($s['student_id']) ?>">Manage</a>
                            <?php if(!$s['is_deleted']): ?>
                                <button class="btn btn-sm btn-outline-danger" type="submit" name="delete_student" value="<?= htmlspecialchars($s['student_id']) ?>" onclick="return confirm('Delete preapproved student?');">Delete</button>
                            <?php else: ?>
                                <button class="btn btn-sm btn-outline-success" type="submit" name="restore_student" value="<?= htmlspecialchars($s['student_id']) ?>" onclick="return confirm('Restore preapproved student?');">Restore</button>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if(empty($students)): ?><tr><td colspan="5" class="text-center py-4">No records found.</td></tr><?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="d-flex flex-wrap gap-2 mt-3">
            <button name="bulk_delete" class="btn btn-danger" onclick="return confirm('Delete selected students?');">Bulk Delete</button>
            <button name="bulk_restore" class="btn btn-secondary" onclick="return confirm('Restore selected students?');">Bulk Restore</button>
        </div>
    </form>
    <p class="muted small mt-3 mb-0">Page <?= $page ?> of <?= $totalPages ?> (Total <?= $total ?> <?= $showDeleted? '(including deleted)':'' ?>, Showing <?= count($students) ?>)</p>
    <div class="d-flex gap-2 mt-2">
        <?php if($page>1): ?><a class="btn btn-outline-secondary btn-sm" href="?q=<?= urlencode($search) ?>&page=<?= $page-1 ?>&perPage=<?= $perPage ?>&sort=<?= urlencode($sort) ?>&dir=<?= urlencode($dir) ?>&showDeleted=<?= $showDeleted ?>">&laquo; Prev</a><?php endif; ?>
        <?php if($page<$totalPages): ?><a class="btn btn-outline-secondary btn-sm" href="?q=<?= urlencode($search) ?>&page=<?= $page+1 ?>&perPage=<?= $perPage ?>&sort=<?= urlencode($sort) ?>&dir=<?= urlencode($dir) ?>&showDeleted=<?= $showDeleted ?>">Next &raquo;</a><?php endif; ?>
    </div>
</section>

<section class="app-card p-4">
    <h3 class="h6">Add Preapproved Student</h3>
    <form method="post" class="row g-3" aria-label="Add preapproved student">
        <?= csrf_field(); ?>
        <div class="col-md-4">
            <label class="form-label small text-uppercase">Student ID</label>
            <input class="form-control" name="student_id" required>
        </div>
        <div class="col-md-4">
            <label class="form-label small text-uppercase">Name</label>
            <input class="form-control" name="student_name">
        </div>
        <div class="col-md-4 d-flex align-items-end">
            <button name="add_student" class="btn btn-primary w-100">Add</button>
        </div>
    </form>
</section>
<script>
function toggleAll(box){
    document.querySelectorAll('input[name="bulk_ids[]"]').forEach(cb=>cb.checked=box.checked);
}
</script>
<?php render_footer(); ?>