<?php
require_once __DIR__ . '/../../src/config.php';
require_login();
$user = current_user();
$attemptId = (int)($_GET['attempt_id'] ?? 0);
if (!$attemptId) { echo 'Missing attempt'; exit; }

$pdo = db();
$stmt = $pdo->prepare('SELECT a.id,a.score,a.submitted_at,p.id AS paper_id, p.title FROM attempts a JOIN papers p ON a.paper_id=p.id WHERE a.id=? AND a.student_id=?');
$stmt->execute([$attemptId, $user['id']]);
$attempt = $stmt->fetch();
if (!$attempt) { echo 'Attempt not found'; exit; }
if (!$attempt['submitted_at']) { echo 'Test not submitted yet'; exit; }

// Get total marks
$totalStmt = $pdo->prepare('SELECT COALESCE(SUM(marks),0) AS total FROM questions WHERE paper_id=?');
$totalStmt->execute([$attempt['paper_id']]);
$totalRow = $totalStmt->fetch();
$totalMarks = (int)$totalRow['total'];
$score = (int)$attempt['score'];
$percentage = $totalMarks > 0 ? round(($score / $totalMarks) * 100) : 0;

// Get questions and responses
$qStmt = $pdo->prepare('SELECT id, question_text, marks, image_path FROM questions WHERE paper_id=? ORDER BY position');
$qStmt->execute([$attempt['paper_id']]);
$questions = $qStmt->fetchAll();
$rStmt = $pdo->prepare('SELECT selected_option_id FROM responses WHERE attempt_id=? AND question_id=?');
$optStmt = $pdo->prepare('SELECT id, option_text, is_correct FROM answer_options WHERE question_id=?');

// Set headers for PDF download
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="result_' . $attemptId . '_' . date('Y-m-d') . '.pdf"');

// Generate HTML content
ob_start();
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Exam Result - <?= htmlspecialchars($attempt['title']) ?></title>
    <style>
        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            margin: 20px;
            color: #333;
            font-size: 11pt;
        }
        .header {
            text-align: center;
            border-bottom: 3px solid #667eea;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        .header h1 {
            color: #667eea;
            margin: 10px 0;
            font-size: 24pt;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .info-box {
            background: #f0f4ff;
            border: 1px solid #667eea;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
        }
        .info-label {
            font-weight: bold;
            color: #667eea;
        }
        .score-box {
            text-align: center;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
        }
        .score-box .percentage {
            font-size: 48pt;
            font-weight: bold;
            margin: 10px 0;
        }
        .score-box .score-text {
            font-size: 16pt;
            margin: 10px 0;
        }
        .question {
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        .question-header {
            background: #f9f9f9;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
        }
        .question-number {
            display: inline-block;
            background: #667eea;
            color: white;
            width: 30px;
            height: 30px;
            line-height: 30px;
            text-align: center;
            border-radius: 50%;
            font-weight: bold;
            margin-right: 10px;
        }
        .question-text {
            font-weight: bold;
            font-size: 12pt;
        }
        .marks-badge {
            float: right;
            background: #ffc107;
            color: white;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 9pt;
        }
        .options {
            margin: 15px 0;
        }
        .option {
            padding: 10px;
            margin: 8px 0;
            border-radius: 5px;
            border: 1px solid #ddd;
        }
        .option.correct {
            background: #d4edda;
            border-color: #28a745;
        }
        .option.incorrect {
            background: #f8d7da;
            border-color: #dc3545;
        }
        .option.neutral {
            background: #fff;
        }
        .option-label {
            font-weight: bold;
            margin-right: 8px;
        }
        .answer-summary {
            display: table;
            width: 100%;
            margin-top: 15px;
        }
        .answer-box {
            display: table-cell;
            width: 50%;
            padding: 12px;
            border-radius: 5px;
        }
        .your-answer {
            background: #e7f3ff;
            border-left: 4px solid #4facfe;
        }
        .correct-answer {
            background: #f0fff4;
            border-left: 4px solid #00d084;
        }
        .answer-box strong {
            display: block;
            margin-bottom: 5px;
            font-size: 10pt;
        }
        .status-badge {
            float: right;
            padding: 8px 15px;
            border-radius: 5px;
            font-weight: bold;
            font-size: 10pt;
        }
        .status-correct {
            background: #00d084;
            color: white;
        }
        .status-incorrect {
            background: #dc3545;
            color: white;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 2px solid #e0e0e0;
            text-align: center;
            color: #999;
            font-size: 9pt;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <h1>📋 Exam Result Report</h1>
        <p><?= htmlspecialchars($attempt['title']) ?></p>
        <p>Student: <?= htmlspecialchars($user['name']) ?> | Date: <?= date('F d, Y', strtotime($attempt['submitted_at'])) ?></p>
    </div>

    <!-- Score Box -->
    <div class="score-box">
        <div class="percentage"><?= $percentage ?>%</div>
        <div class="score-text"><?= $score ?> out of <?= $totalMarks ?> marks</div>
        <div>
            <?php if ($percentage >= 90) { echo '🎯 Excellent Performance'; }
            elseif ($percentage >= 80) { echo '⭐ Very Good'; }
            elseif ($percentage >= 70) { echo '👍 Good'; }
            elseif ($percentage >= 60) { echo '✓ Satisfactory'; }
            else { echo '📚 Keep Practicing'; } ?>
        </div>
    </div>

    <!-- Info Box -->
    <div class="info-box">
        <div class="info-row">
            <span class="info-label">Total Questions:</span>
            <span><?= count($questions) ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Submitted On:</span>
            <span><?= date('F d, Y H:i', strtotime($attempt['submitted_at'])) ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Percentage:</span>
            <span><?= $percentage ?>%</span>
        </div>
    </div>

    <!-- Questions and Answers -->
    <h2 style="color: #667eea; margin-bottom: 20px;">📝 Detailed Answer Review</h2>

    <?php foreach ($questions as $idx => $q): ?>
        <?php 
        $rStmt->execute([$attemptId, $q['id']]); 
        $resp = $rStmt->fetch(); 
        $selectedId = $resp['selected_option_id'] ?? null;
        
        $optStmt->execute([$q['id']]);
        $opts = $optStmt->fetchAll();
        $correct = null; 
        $correctIndex = null;
        foreach ($opts as $i => $o) {
            if ($o['is_correct']) { 
                $correct = $o; 
                $correctIndex = $i; 
                break; 
            }
        }
        $correctLabel = is_null($correctIndex) ? null : chr(ord('A') + $correctIndex);

        $selectedOption = null; 
        $selectedIndex = null;
        if ($selectedId) {
            foreach ($opts as $i => $o) {
                if ($o['id'] == $selectedId) { 
                    $selectedOption = $o; 
                    $selectedIndex = $i; 
                    break; 
                }
            }
        }
        $selectedLabel = is_null($selectedIndex) ? null : chr(ord('A') + $selectedIndex);
        $isCorrect = ($selectedId && $correct && $selectedId == $correct['id']);
        ?>
        
        <div class="question">
            <div class="question-header">
                <span class="marks-badge">★ <?= $q['marks'] ?> mark<?= $q['marks']==1?'':'s' ?></span>
                <span class="status-badge <?= $isCorrect ? 'status-correct' : 'status-incorrect' ?>">
                    <?= $isCorrect ? '✓ Correct' : '✗ Incorrect' ?>
                </span>
                <span class="question-number">Q<?= $idx+1 ?></span>
                <span class="question-text"><?= htmlspecialchars($q['question_text']) ?></span>
            </div>

            <div class="options">
                <?php foreach ($opts as $i => $o): ?>
                    <?php 
                    $isSel = ($selectedId && $selectedId == $o['id']); 
                    $isCor = (bool)$o['is_correct']; 
                    $label = chr(ord('A') + $i);
                    $optClass = $isCor ? 'correct' : ($isSel ? 'incorrect' : 'neutral');
                    ?>
                    <div class="option <?= $optClass ?>">
                        <span style="font-size: 14pt; margin-right: 10px;">
                            <?php if ($isCor && $isSel) { echo '✅'; }
                            elseif ($isCor) { echo '✓'; }
                            elseif ($isSel) { echo '❌'; }
                            else { echo '○'; } ?>
                        </span>
                        <span class="option-label"><?= $label ?>.</span>
                        <?= htmlspecialchars($o['option_text']) ?>
                        <?php if ($isSel) { echo '<strong style="color: #dc3545;"> (your choice)</strong>'; } ?>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="answer-summary">
                <div class="answer-box your-answer">
                    <strong>👤 Your Answer:</strong>
                    <?= $selectedOption ? htmlspecialchars(($selectedLabel ? $selectedLabel . '. ' : '') . $selectedOption['option_text']) : 'No answer provided' ?>
                </div>
                <div class="answer-box correct-answer" style="margin-left: 10px;">
                    <strong>🎯 Correct Answer:</strong>
                    <?= $correct ? htmlspecialchars(($correctLabel ? $correctLabel . '. ' : '') . $correct['option_text']) : 'N/A' ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>

    <!-- Footer -->
    <div class="footer">
        <p>Generated on <?= date('F d, Y H:i:s') ?></p>
        <p>This is an official exam result report. Keep it for your records.</p>
    </div>
</body>
</html>
<?php
$html = ob_get_clean();

// Try using FPDF (should be installed in src/)
$fpdfPath = __DIR__ . '/../../src/fpdf.php';

if (file_exists($fpdfPath)) {
    require_once $fpdfPath;
    
    try {
        // Create PDF using FPDF
        $pdf = new FPDF('P', 'mm', 'A4');
        $pdf->SetAutoPageBreak(true, 15);
        $pdf->AddPage();
        
        // Header
        $pdf->SetFont('Arial', 'B', 20);
        $pdf->SetTextColor(102, 126, 234);
        $pdf->Cell(0, 10, iconv('UTF-8', 'ISO-8859-1//TRANSLIT', '📋 Exam Result Report'), 0, 1, 'C');
        $pdf->Ln(2);
        
        $pdf->SetFont('Arial', '', 12);
        $pdf->SetTextColor(0, 0, 0);
        $pdf->Cell(0, 6, iconv('UTF-8', 'ISO-8859-1//TRANSLIT', $attempt['title']), 0, 1, 'C');
        $pdf->Cell(0, 6, 'Student: ' . iconv('UTF-8', 'ISO-8859-1//TRANSLIT', $user['name']) . ' | Date: ' . date('F d, Y', strtotime($attempt['submitted_at'])), 0, 1, 'C');
        $pdf->Ln(5);
        
        // Score Box
        $pdf->SetFillColor(102, 126, 234);
        $pdf->SetTextColor(255, 255, 255);
        $pdf->Rect(20, $pdf->GetY(), 170, 35, 'F');
        
        $pdf->SetFont('Arial', 'B', 36);
        $pdf->SetXY(20, $pdf->GetY() + 8);
        $pdf->Cell(170, 10, $percentage . '%', 0, 1, 'C');
        
        $pdf->SetFont('Arial', '', 14);
        $pdf->SetX(20);
        $pdf->Cell(170, 8, $score . ' out of ' . $totalMarks . ' marks', 0, 1, 'C');
        
        $pdf->Ln(8);
        
        // Performance text
        $perfText = '';
        if ($percentage >= 90) { $perfText = 'Excellent Performance'; }
        elseif ($percentage >= 80) { $perfText = 'Very Good'; }
        elseif ($percentage >= 70) { $perfText = 'Good'; }
        elseif ($percentage >= 60) { $perfText = 'Satisfactory'; }
        else { $perfText = 'Keep Practicing'; }
        
        $pdf->SetTextColor(0, 0, 0);
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(0, 6, $perfText, 0, 1, 'C');
        $pdf->Ln(5);
        
        // Info Box
        $pdf->SetFillColor(240, 244, 255);
        $pdf->SetDrawColor(102, 126, 234);
        $pdf->Rect(20, $pdf->GetY(), 170, 20, 'FD');
        
        $y = $pdf->GetY() + 4;
        $pdf->SetFont('Arial', 'B', 10);
        $pdf->SetXY(25, $y);
        $pdf->Cell(80, 5, 'Total Questions:', 0, 0);
        $pdf->SetFont('Arial', '', 10);
        $pdf->Cell(0, 5, count($questions), 0, 1);
        
        $pdf->SetFont('Arial', 'B', 10);
        $pdf->SetX(25);
        $pdf->Cell(80, 5, 'Submitted On:', 0, 0);
        $pdf->SetFont('Arial', '', 10);
        $pdf->Cell(0, 5, date('F d, Y H:i', strtotime($attempt['submitted_at'])), 0, 1);
        
        $pdf->SetFont('Arial', 'B', 10);
        $pdf->SetX(25);
        $pdf->Cell(80, 5, 'Percentage:', 0, 0);
        $pdf->SetFont('Arial', '', 10);
        $pdf->Cell(0, 5, $percentage . '%', 0, 1);
        
        $pdf->Ln(8);
        
        // Section Header
        $pdf->SetFont('Arial', 'B', 14);
        $pdf->SetTextColor(102, 126, 234);
        $pdf->Cell(0, 8, 'Detailed Answer Review', 0, 1);
        $pdf->Ln(3);
        
        // Questions
        foreach ($questions as $idx => $q) {
            $rStmt->execute([$attemptId, $q['id']]); 
            $resp = $rStmt->fetch(); 
            $selectedId = $resp['selected_option_id'] ?? null;
            
            $optStmt->execute([$q['id']]);
            $opts = $optStmt->fetchAll();
            
            $correct = null; 
            $correctIndex = null;
            foreach ($opts as $i => $o) {
                if ($o['is_correct']) { 
                    $correct = $o; 
                    $correctIndex = $i; 
                    break; 
                }
            }
            
            $selectedOption = null; 
            $selectedIndex = null;
            if ($selectedId) {
                foreach ($opts as $i => $o) {
                    if ($o['id'] == $selectedId) { 
                        $selectedOption = $o; 
                        $selectedIndex = $i; 
                        break; 
                    }
                }
            }
            
            $isCorrect = ($selectedId && $correct && $selectedId == $correct['id']);
            
            // Check if we need a new page
            if ($pdf->GetY() > 240) {
                $pdf->AddPage();
            }
            
            // Question Box
            $pdf->SetDrawColor(224, 224, 224);
            $startY = $pdf->GetY();
            
            // Question Header
            $pdf->SetFillColor(249, 249, 249);
            $pdf->Rect(15, $startY, 180, 12, 'FD');
            
            // Question Number
            $pdf->SetFillColor(102, 126, 234);
            $pdf->SetTextColor(255, 255, 255);
            $pdf->SetFont('Arial', 'B', 10);
            // Draw a circle using a filled rectangle with rounded corners approximation
            $pdf->SetXY(21, $startY + 3);
            $pdf->Cell(8, 6, 'Q' . ($idx + 1), 0, 0, 'C', true);
            
            // Question Text
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', 'B', 11);
            $pdf->SetXY(33, $startY + 3);
            $questionText = iconv('UTF-8', 'ISO-8859-1//TRANSLIT', substr($q['question_text'], 0, 80));
            if (strlen($q['question_text']) > 80) $questionText .= '...';
            $pdf->Cell(120, 6, $questionText, 0, 0);
            
            // Status Badge
            if ($isCorrect) {
                $pdf->SetFillColor(0, 208, 132);
                $pdf->SetTextColor(255, 255, 255);
            } else {
                $pdf->SetFillColor(220, 53, 69);
                $pdf->SetTextColor(255, 255, 255);
            }
            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetXY(160, $startY + 3);
            $pdf->Cell(30, 6, $isCorrect ? 'Correct' : 'Incorrect', 0, 1, 'C', true);
            
            $pdf->SetY($startY + 14);
            
            // Options
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('Arial', '', 9);
            
            foreach ($opts as $i => $o) {
                if ($pdf->GetY() > 260) {
                    $pdf->AddPage();
                }
                
                $isSel = ($selectedId && $selectedId == $o['id']); 
                $isCor = (bool)$o['is_correct']; 
                $label = chr(ord('A') + $i);
                
                // Option background
                if ($isCor) {
                    $pdf->SetFillColor(212, 237, 218);
                    $pdf->SetDrawColor(40, 167, 69);
                } elseif ($isSel) {
                    $pdf->SetFillColor(248, 215, 218);
                    $pdf->SetDrawColor(220, 53, 69);
                } else {
                    $pdf->SetFillColor(255, 255, 255);
                    $pdf->SetDrawColor(221, 221, 221);
                }
                
                $optY = $pdf->GetY();
                $pdf->Rect(20, $optY, 170, 8, 'FD');
                
                // Icon
                $icon = '';
                if ($isCor && $isSel) { $icon = '[X]'; }
                elseif ($isCor) { $icon = '[+]'; }
                elseif ($isSel) { $icon = '[!]'; }
                else { $icon = '[ ]'; }
                
                $pdf->SetXY(22, $optY + 2);
                $pdf->SetFont('Arial', 'B', 9);
                $pdf->Cell(8, 4, $icon, 0, 0);
                
                $pdf->SetFont('Arial', 'B', 9);
                $pdf->Cell(5, 4, $label . '.', 0, 0);
                
                $pdf->SetFont('Arial', '', 9);
                $optText = iconv('UTF-8', 'ISO-8859-1//TRANSLIT', substr($o['option_text'], 0, 70));
                if (strlen($o['option_text']) > 70) $optText .= '...';
                $pdf->Cell(140, 4, $optText, 0, 0);
                
                if ($isSel) {
                    $pdf->SetFont('Arial', 'B', 8);
                    $pdf->SetTextColor(220, 53, 69);
                    $pdf->Cell(0, 4, '(your choice)', 0, 1);
                    $pdf->SetTextColor(0, 0, 0);
                } else {
                    $pdf->Ln();
                }
                
                $pdf->Ln(1);
            }
            
            $pdf->Ln(3);
        }
        
        // Footer
        $pdf->SetY(-20);
        $pdf->SetFont('Arial', 'I', 8);
        $pdf->SetTextColor(150, 150, 150);
        $pdf->Cell(0, 5, 'Generated on ' . date('F d, Y H:i:s'), 0, 1, 'C');
        $pdf->Cell(0, 5, 'This is an official exam result report. Keep it for your records.', 0, 1, 'C');
        
        // Output PDF
        $pdf->Output('D', 'result_' . $attemptId . '_' . date('Y-m-d') . '.pdf');
        exit;
        
    } catch (Exception $e) {
        // If FPDF fails, fall back to HTML
    }
}

// Fallback: Return print-friendly HTML that browser can convert to PDF
header('Content-Type: text/html; charset=utf-8');
header('Content-Disposition: inline; filename="result_' . $attemptId . '.html"');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Exam Result - Print to PDF</title>
    <style>
        @media print {
            body { margin: 0; }
            .no-print { display: none; }
        }
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            color: #333;
        }
        .print-instructions {
            background: #fff3cd;
            border: 2px solid #ffc107;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 30px;
            text-align: center;
        }
        .print-button {
            background: #667eea;
            color: white;
            border: none;
            padding: 15px 30px;
            font-size: 16pt;
            border-radius: 8px;
            cursor: pointer;
            font-weight: bold;
        }
        .print-button:hover {
            background: #5568d3;
        }
    </style>
    <script>
        function printPDF() {
            window.print();
        }
    </script>
</head>
<body>
    <div class="print-instructions no-print">
        <h2 style="color: #667eea; margin-bottom: 15px;">📥 Download Your Result as PDF</h2>
        <p style="margin-bottom: 20px; font-size: 12pt;">
            Click the button below to open your browser's print dialog.<br>
            <strong>Select "Save as PDF" or "Microsoft Print to PDF"</strong> as your printer.
        </p>
        <button class="print-button" onclick="printPDF()">
            🖨️ Print / Save as PDF
        </button>
        <p style="margin-top: 15px; color: #666; font-size: 10pt;">
            Or press <kbd>Ctrl+P</kbd> (Windows) / <kbd>Cmd+P</kbd> (Mac)
        </p>
    </div>
    
    <?= $html ?>
</body>
</html>
