<?php
header('Content-Type: text/html; charset=UTF-8');
mb_internal_encoding('UTF-8');
mb_http_output('UTF-8');
require_once __DIR__ . '/../../src/config.php';
require_once __DIR__ . '/../../src/csrf.php';
require_once __DIR__ . '/../../src/layout.php';
require_login();
$user = current_user();
if ($user['user_type'] !== 'teacher') { http_response_code(403); echo 'Forbidden'; exit; }

$errors = [];
$success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_verify()) { $errors[] = 'Invalid CSRF token'; }
    $title = trim($_POST['title'] ?? '');
    $fee = (int)($_POST['fee_cents'] ?? 0);
    $timeLimit = (int)($_POST['time_limit_minutes'] ?? 0) * 60;
    $questions = $_POST['questions'] ?? [];
    $options = $_POST['options'] ?? [];
    $correct = $_POST['correct'] ?? [];
    $publish = isset($_POST['publish']) ? 1 : 0;

    if (!$title || $timeLimit <= 0) { $errors[] = 'Title and time limit required.'; }
    if (empty($questions)) { $errors[] = 'At least one question required.'; }

    if (!$errors) {
        $pdo = db();
        $pdo->beginTransaction();
        try {
            $stmt = $pdo->prepare('INSERT INTO papers (teacher_id,title,fee_cents,time_limit_seconds,is_published) VALUES (?,?,?,?,?)');
            $stmt->execute([$user['id'], $title, $fee, $timeLimit, $publish]);
            $paperId = $pdo->lastInsertId();
            foreach ($questions as $i => $qText) {
                $qText = trim($qText);
                if ($qText === '') { continue; }
                $marks = (int)($_POST['marks'][$i] ?? 1);
                if ($marks < 1) $marks = 1;
                
                // Handle image upload for question
                $imagePath = null;
                if (isset($_FILES['question_images']) && isset($_FILES['question_images']['tmp_name'][$i]) && $_FILES['question_images']['tmp_name'][$i]) {
                    $file = $_FILES['question_images'];
                    $tmpFile = $file['tmp_name'][$i];
                    $fileName = $file['name'][$i];
                    $fileType = pathinfo($fileName, PATHINFO_EXTENSION);
                    
                    // Validate image and PDF
                    if (in_array(strtolower($fileType), ['jpg', 'jpeg', 'png', 'gif', 'webp', 'pdf'])) {
                        $newFileName = 'q_' . time() . '_' . bin2hex(random_bytes(4)) . '.' . $fileType;
                        $uploadDir = __DIR__ . '/uploads/questions/';
                        if (!is_dir($uploadDir)) @mkdir($uploadDir, 0755, true);
                        
                        $destFile = $uploadDir . $newFileName;
                        if (move_uploaded_file($tmpFile, $destFile)) {
                            $imagePath = 'uploads/questions/' . $newFileName;
                        }
                    }
                }
                
                $stmtQ = $pdo->prepare('INSERT INTO questions (paper_id,question_text,marks,position,image_path) VALUES (?,?,?,?,?)');
                $stmtQ->execute([$paperId, $qText, $marks, $i + 1, $imagePath]);
                $questionId = $pdo->lastInsertId();
                $opts = $options[$i] ?? [];
                foreach ($opts as $j => $optText) {
                    $stmtO = $pdo->prepare('INSERT INTO answer_options (question_id,option_text,is_correct) VALUES (?,?,?)');
                    $stmtO->execute([$questionId, trim($optText), ($correct[$i] ?? -1) == $j ? 1 : 0]);
                }
            }
            $pdo->commit();
            $success = 'Paper created (ID ' . $paperId . ').';
        } catch (Exception $e) {
            $pdo->rollBack();
            $errors[] = 'Error: ' . $e->getMessage();
        }
    }
}
render_header('Create Paper');
?>

<!-- Load jQuery first for MathQuill -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

<!-- MathQuill CSS & JS for visual math editor -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/mathquill/0.10.1/mathquill.min.css" crossorigin="anonymous" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/mathquill/0.10.1/mathquill.min.js" crossorigin="anonymous"></script>

<!-- Load KaTeX for math rendering -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/katex@0.16.9/dist/katex.min.css" />
<script src="https://cdn.jsdelivr.net/npm/katex@0.16.9/dist/katex.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/katex@0.16.9/dist/contrib/auto-render.min.js"></script>

<script>
  // Initialize KaTeX rendering when script loads
  function renderMath() {
    if (window.renderMathInElement) {
      try {
        window.renderMathInElement(document.body, {
          delimiters: [
            {left: '$$', right: '$$', display: true},
            {left: '$', right: '$', display: false},
            {left: '\\[', right: '\\]', display: true},
            {left: '\\(', right: '\\)', display: false}
          ],
          throwOnError: false
        });
      } catch(err) {
        console.log('KaTeX render error:', err.message);
      }
    }
  }
  
  // Render when DOM is ready
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', renderMath);
  } else {
    renderMath();
  }
</script>

<!-- Hero Section -->
<section style="background: linear-gradient(135deg, #000000 0%, #232222 100%); border-radius: 12px; padding: 3rem; color: white; margin-bottom: 3rem; position: relative; overflow: hidden;">
  <div style="position: absolute; top: 0; right: 0; font-size: 8rem; opacity: 0.1;">
    <i class="bi bi-pencil-square"></i>
  </div>
  <div class="position-relative">
    <h1 class="mb-2" style="font-size: 2.5rem; font-weight: 700;">
      <i class="bi bi-pencil-square me-2"></i>Create New Paper
    </h1>
    <p style="opacity: 0.95; font-size: 1.1rem; margin: 0;">Build MCQ papers and publish to your students</p>
  </div>
</section>

<!-- Info Cards -->
<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 1.5rem; margin-bottom: 3rem;">
  <!-- Status Card -->
  <div style="background: white; border-radius: 12px; padding: 1.5rem; box-shadow: 0 2px 8px rgba(0,0,0,0.08); border-left: 4px solid #667eea;">
    <div style="display: flex; align-items: flex-start; justify-content: space-between; gap: 1rem;">
      <div style="flex: 1;">
        <p style="margin: 0 0 0.5rem 0; color: #999; font-size: 0.9rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">Status</p>
        <p style="margin: 0; font-weight: 700; color: #667eea; font-size: 1.8rem;">Draft</p>
        <p style="margin: 0.5rem 0 0 0; color: #666; font-size: 0.85rem;">Hidden until published</p>
      </div>
      <div style="width: 50px; height: 50px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 10px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1.5rem; flex-shrink: 0;">
        <i class="bi bi-file-earmark-text"></i>
      </div>
    </div>
  </div>

  <!-- Questions Card -->
  <div style="background: white; border-radius: 12px; padding: 1.5rem; box-shadow: 0 2px 8px rgba(0,0,0,0.08); border-left: 4px solid #4facfe;">
    <div style="display: flex; align-items: flex-start; justify-content: space-between; gap: 1rem;">
      <div style="flex: 1;">
        <p style="margin: 0 0 0.5rem 0; color: #999; font-size: 0.9rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">Questions</p>
        <p style="margin: 0; font-weight: 700; color: #4facfe; font-size: 1.8rem;" id="questionCount">0</p>
        <p style="margin: 0.5rem 0 0 0; color: #666; font-size: 0.85rem;">Keep adding MCQs</p>
      </div>
      <div style="width: 50px; height: 50px; background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); border-radius: 10px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1.5rem; flex-shrink: 0;">
        <i class="bi bi-chat-left-text"></i>
      </div>
    </div>
  </div>

  <!-- Time Limit Card -->
  <div style="background: white; border-radius: 12px; padding: 1.5rem; box-shadow: 0 2px 8px rgba(0,0,0,0.08); border-left: 4px solid #ffc107;">
    <div style="display: flex; align-items: flex-start; justify-content: space-between; gap: 1rem;">
      <div style="flex: 1;">
        <p style="margin: 0 0 0.5rem 0; color: #999; font-size: 0.9rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">Time Limit</p>
        <p style="margin: 0; font-weight: 700; color: #ffc107; font-size: 1.8rem;" id="timeLimitDisplay">30 min</p>
        <p style="margin: 0.5rem 0 0 0; color: #666; font-size: 0.85rem;">Adjust as needed</p>
      </div>
      <div style="width: 50px; height: 50px; background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%); border-radius: 10px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1.5rem; flex-shrink: 0;">
        <i class="bi bi-hourglass-split"></i>
      </div>
    </div>
  </div>
</div>

<!-- Form Section -->
<section style="background: white; border-radius: 12px; padding: 0; box-shadow: 0 2px 8px rgba(0,0,0,0.08); overflow: hidden; margin-bottom: 3rem;">
  <div style="background: linear-gradient(135deg, #000000 0%, #211517 100%); padding: 1.5rem; color: white; border-bottom: 4px solid #000000;">
    <h2 class="h5 mb-0 d-flex align-items-center gap-2" style="font-weight: 700;">
      <i class="bi bi-gear" style="font-size: 1.3rem;"></i>Paper Details
    </h2>
  </div>
  <div style="padding: 2rem;">
    <?php foreach ($errors as $e): ?>
      <div style="background: #fee; border-left: 4px solid #dc3545; padding: 1rem; border-radius: 8px; margin-bottom: 1rem; color: #dc3545;">
        <i class="bi bi-exclamation-circle-fill me-2"></i><?= htmlspecialchars($e) ?>
      </div>
    <?php endforeach; ?>
    <?php if ($success): ?>
      <div style="background: #efe; border-left: 4px solid #00d084; padding: 1rem; border-radius: 8px; margin-bottom: 1rem; color: #00d084;">
        <i class="bi bi-check-circle-fill me-2"></i><?= htmlspecialchars($success) ?>
      </div>
    <?php endif; ?>
    
    <form method="post" id="paperForm" accept-charset="UTF-8">
      <?= csrf_field(); ?>
      
      <!-- Paper Basics -->
      <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1.5rem; margin-bottom: 2rem;">
        <div>
          <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">
            <i class="bi bi-heading me-1" style="color: #f5576c;"></i>Paper Title
          </label>
          <input class="form-control" name="title" required style="border-radius: 8px; border: 2px solid #e9ecef; padding: 0.75rem; font-size: 1rem;">
        </div>
        <div>
          <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">
            <i class="bi bi-tag me-1" style="color: #4facfe;"></i>Fee (cents)
          </label>
          <input type="number" class="form-control" name="fee_cents" value="0" min="0" style="border-radius: 8px; border: 2px solid #e9ecef; padding: 0.75rem; font-size: 1rem;">
        </div>
        <div>
          <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">
            <i class="bi bi-hourglass-split me-1" style="color: #ffc107;"></i>Time Limit (minutes)
          </label>
          <input type="number" class="form-control" name="time_limit_minutes" id="timeLimit" value="30" min="1" required style="border-radius: 8px; border: 2px solid #e9ecef; padding: 0.75rem; font-size: 1rem;">
        </div>
      </div>

      <!-- Publish Option -->
      <div style="background: #f9f9f9; padding: 1rem; border-radius: 8px; margin-bottom: 2rem; border-left: 4px solid #667eea;">
        <label class="d-flex align-items-center gap-2" style="cursor: pointer; margin: 0;">
          <input type="checkbox" class="form-check-input" id="publishNow" name="publish" value="1" style="width: 20px; height: 20px; cursor: pointer;">
          <span style="font-weight: 600; color: #333;">Publish immediately</span>
        </label>
        <p style="margin: 0.5rem 0 0 28px; color: #666; font-size: 0.85rem;">Paper will be visible to students right away</p>
      </div>

      <hr style="margin: 2rem 0; border: none; border-top: 2px solid #e9ecef;">

      <!-- Questions Section Header -->
      <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h3 class="h5 mb-0" style="font-weight: 700; color: #333;">
          <i class="bi bi-chat-left-text me-2" style="color: #4facfe;"></i>Questions
        </h3>
        <button type="button" class="btn btn-sm" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); color: white; border: none; font-weight: 600; padding: 0.5rem 1rem; border-radius: 8px;" onclick="addQuestion()">
          <i class="bi bi-plus-circle me-1"></i>Add Question
        </button>
      </div>

      <!-- Questions Container -->
      <div id="questions" style="display: flex; flex-direction: column; gap: 1.5rem; margin-bottom: 2rem;" aria-live="polite"></div>

      <!-- Form Actions -->
      <div style="display: flex; flex-wrap: wrap; gap: 1rem; padding-top: 2rem; border-top: 2px solid #e9ecef;">
        <button type="submit" class="btn btn-sm" style="background: linear-gradient(135deg, #00d084 0%, #13c084 100%); color: white; border: none; font-weight: 600; padding: 0.75rem 1.5rem; border-radius: 8px;">
          <i class="bi bi-save me-1"></i>Save Paper
        </button>
        <button type="button" class="btn btn-sm" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); color: white; border: none; font-weight: 600; padding: 0.75rem 1.5rem; border-radius: 8px;" onclick="addQuestion()">
          <i class="bi bi-plus me-1"></i>Add Another Question
        </button>
        <a class="btn btn-sm" href="<?= htmlspecialchars(app_href('teacher/manage_papers.php')) ?>" style="background: white; color: #667eea; border: 2px solid #667eea; font-weight: 600; padding: 0.5rem 1rem; border-radius: 8px; text-decoration: none;">
          <i class="bi bi-arrow-left me-1"></i>Back to Papers
        </a>
      </div>

      <p style="margin: 1.5rem 0 0 0; color: #999; font-size: 0.85rem;">
        <i class="bi bi-lightbulb-fill me-1" style="color: #ffc107;"></i><strong>Tip:</strong> Select the correct answer using the radio button for each question, or results will show "N/A".
      </p>
    </form>
  </div>
</section>
<script>
let qIndex = 0;

// Math equation templates
const mathTemplates = {
  'Quadratic Formula': '$$x = \\frac{-b \\pm \\sqrt{b^2-4ac}}{2a}$$',
  'Pythagorean Theorem': '$$a^2 + b^2 = c^2$$',
  'Fraction': '$$\\frac{numerator}{denominator}$$',
  'Square Root': '$$\\sqrt{x}$$',
  'Superscript': '$$x^n$$',
  'Greek Letters': '$$\\alpha, \\beta, \\gamma, \\pi, \\omega$$',
  'Integral': '$$\\int_a^b f(x) \\, dx$$',
  'Summation': '$$\\sum_{i=1}^{n} a_i$$',
};

function showMathHelper(btn) {
  const textarea = btn.closest('div').querySelector('.question-text');
  const modal = document.createElement('div');
  modal.style.cssText = 'position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.7); display: flex; align-items: center; justify-content: center; z-index: 9999; padding: 1rem;';
  
  // Symbol categories like Google Forms
  const symbolCategories = {
    'Basic': [
      {char: '+', latex: '+'},
      {char: '−', latex: '-'},
      {char: '×', latex: '\\times'},
      {char: '÷', latex: '\\div'},
      {char: '=', latex: '='},
      {char: '≠', latex: '\\neq'},
      {char: '>', latex: '>'},
      {char: '<', latex: '<'},
      {char: '≥', latex: '\\geq'},
      {char: '≤', latex: '\\leq'},
    ],
    'Fractions & Roots': [
      {char: '⁄', latex: '\\frac{}{}'}, 
      {char: '√', latex: '\\sqrt{}'},
      {char: '∛', latex: '\\sqrt[3]{}'},
      {char: '∜', latex: '\\sqrt[4]{}'},
    ],
    'Exponents & Subscripts': [
      {char: 'x²', latex: '^2'},
      {char: 'xⁿ', latex: '^{}'},
      {char: 'x₂', latex: '_{}'},
      {char: '()', latex: '()'},
      {char: '[]', latex: '[]'},
    ],
    'Greek Letters': [
      {char: 'α', latex: '\\alpha'},
      {char: 'β', latex: '\\beta'},
      {char: 'γ', latex: '\\gamma'},
      {char: 'δ', latex: '\\delta'},
      {char: 'π', latex: '\\pi'},
      {char: 'Σ', latex: '\\Sigma'},
      {char: 'θ', latex: '\\theta'},
      {char: 'ω', latex: '\\omega'},
      {char: 'λ', latex: '\\lambda'},
      {char: 'μ', latex: '\\mu'},
    ],
    'Calculus': [
      {char: '∫', latex: '\\int'},
      {char: '∫∫', latex: '\\iint'},
      {char: '∑', latex: '\\sum'},
      {char: 'Π', latex: '\\prod'},
      {char: '∞', latex: '\\infty'},
      {char: '∂', latex: '\\partial'},
      {char: '∇', latex: '\\nabla'},
      {char: '∆', latex: '\\Delta'},
    ],
    'Logic & Sets': [
      {char: '∀', latex: '\\forall'},
      {char: '∃', latex: '\\exists'},
      {char: '∈', latex: '\\in'},
      {char: '∉', latex: '\\notin'},
      {char: '⊂', latex: '\\subset'},
      {char: '∪', latex: '\\cup'},
      {char: '∩', latex: '\\cap'},
      {char: '∅', latex: '\\emptyset'},
    ],
    'Arrows': [
      {char: '←', latex: '\\leftarrow'},
      {char: '→', latex: '\\rightarrow'},
      {char: '↑', latex: '\\uparrow'},
      {char: '↓', latex: '\\downarrow'},
      {char: '⇒', latex: '\\Rightarrow'},
      {char: '⟹', latex: '\\implies'},
    ],
  };
  
  let htmlContent = `
    <div style="background: white; border-radius: 12px; padding: 0; max-width: 900px; box-shadow: 0 10px 40px rgba(0,0,0,0.3); max-height: 85vh; overflow: hidden; display: flex; flex-direction: column;">
      <!-- Header -->
      <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 1.5rem; display: flex; justify-content: space-between; align-items: center;">
        <h4 style="margin: 0; font-weight: 700; font-size: 1.2rem;">
          <i class="bi bi-calculator-fill me-2"></i>Insert Math Equation
        </h4>
        <button type="button" style="background: none; border: none; font-size: 1.8rem; cursor: pointer; color: white; opacity: 0.8;" onclick="this.closest('[style*=position]').remove()">×</button>
      </div>
      
      <!-- LaTeX Input & Preview -->
      <div style="background: #f8f9fa; padding: 1rem; border-bottom: 1px solid #e9ecef;">
        <div class="grid-auto-fit" style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
          <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333; font-size: 0.9rem;">LaTeX Code</label>
            <input type="text" id="latexInput" placeholder="e.g., x = \\frac{-b \\pm \\sqrt{b^2-4ac}}{2a}" style="width: 100%; border-radius: 6px; border: 1px solid #ddd; padding: 0.75rem; font-family: monospace; font-size: 0.9rem; min-height: 44px;" />
            <small style="display: block; margin-top: 0.5rem; color: #666; font-size: 0.85rem;">Type or click symbols below</small>
          </div>
          <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333; font-size: 0.9rem;">Live Preview</label>
            <div id="mathPreview" style="border-radius: 6px; border: 1px solid #ddd; padding: 0.75rem; background: white; min-height: 44px; font-size: 1.1rem; display: flex; align-items: center; justify-content: center; overflow: auto;">
              (preview here)
            </div>
          </div>
        </div>
      </div>
      
      <!-- Symbol Categories (Tabs) -->
      <div style="display: flex; border-bottom: 1px solid #e9ecef; background: white; overflow-x: auto;">`;
  
  Object.keys(symbolCategories).forEach((cat, idx) => {
    const isActive = idx === 0 ? 'background: #f0f0f0; border-bottom: 3px solid #667eea;' : '';
    htmlContent += `
      <button type="button" class="category-tab" data-category="${cat}" style="padding: 0.75rem 1rem; border: none; cursor: pointer; font-weight: 600; color: #333; ${isActive} flex-shrink: 0; transition: all 0.2s;">
        ${cat}
      </button>`;
  });
  
  htmlContent += `</div>
      
      <!-- Symbol Grid -->
      <div style="flex: 1; overflow-y: auto; padding: 1.5rem; padding-top: 1rem;">
        <div id="symbolGrid" class="grid-auto-fit" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(60px, 1fr)); gap: 0.75rem;"></div>
      </div>
      
      <!-- Action Buttons -->
      <div style="background: #f8f9fa; padding: 1rem; border-top: 1px solid #e9ecef; display: flex; gap: 0.75rem; flex-wrap: wrap;">
        <button type="button" class="btn" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none; flex: 1; min-height: 44px; cursor: pointer;" onclick="insertMathEquation()">
          <i class="bi bi-check-circle me-1"></i>OK
        </button>
        <button type="button" class="btn" style="background: #f0f0f0; color: #333; border: 1px solid #ddd; flex: 1; min-height: 44px; cursor: pointer;" onclick="this.closest('[style*=position]').remove()">
          Cancel
        </button>
      </div>
    </div>
  `;
  
  modal.innerHTML = htmlContent;
  document.body.appendChild(modal);
  
  // Store textarea reference
  window.currentTextarea = textarea;
  
  // Initialize symbol grid
  function renderSymbols(category) {
    const grid = document.getElementById('symbolGrid');
    grid.innerHTML = '';
    
    (symbolCategories[category] || symbolCategories['Basic']).forEach(symbol => {
      const btn = document.createElement('button');
      btn.type = 'button';
      btn.style.cssText = `
        background: white; border: 2px solid #e9ecef; border-radius: 6px; padding: 1rem;
        cursor: pointer; font-weight: 600; font-size: 1.2rem; color: #333;
        transition: all 0.2s; text-align: center;
      `;
      btn.textContent = symbol.char;
      btn.title = symbol.latex;
      btn.onmouseover = () => btn.style.cssText += 'background: #f0f0f0; border-color: #667eea;';
      btn.onmouseout = () => btn.style.cssText = `
        background: white; border: 2px solid #e9ecef; border-radius: 6px; padding: 1rem;
        cursor: pointer; font-weight: 600; font-size: 1.2rem; color: #333;
        transition: all 0.2s; text-align: center;
      `;
      btn.onclick = () => {
        const input = document.getElementById('latexInput');
        input.value += symbol.latex + ' ';
        input.focus();
        updatePreview();
      };
      grid.appendChild(btn);
    });
  }
  
  // Category tab switching
  document.querySelectorAll('.category-tab').forEach(tab => {
    tab.onclick = () => {
      document.querySelectorAll('.category-tab').forEach(t => t.style.cssText = 'padding: 0.75rem 1rem; border: none; cursor: pointer; font-weight: 600; color: #333; flex-shrink: 0; transition: all 0.2s;');
      tab.style.cssText = 'padding: 0.75rem 1rem; border: none; cursor: pointer; font-weight: 600; color: #333; flex-shrink: 0; transition: all 0.2s; background: #f0f0f0; border-bottom: 3px solid #667eea;';
      renderSymbols(tab.dataset.category);
    };
  });
  
  // Live preview
  function updatePreview() {
    const input = document.getElementById('latexInput');
    const preview = document.getElementById('mathPreview');
    preview.textContent = input.value || '(preview here)';
    // Re-render if KaTeX available
    if (window.renderMathInElement) {
      try {
        window.renderMathInElement(preview, {
          delimiters: [{left: '', right: '', display: true}],
          throwOnError: false
        });
      } catch(e) {}
    }
  }
  
  document.getElementById('latexInput').oninput = updatePreview;
  
  // Initial render
  renderSymbols('Basic');
  
  // Close on modal background click
  modal.addEventListener('click', (e) => {
    if (e.target === modal) modal.remove();
  });
}

function insertMathEquation() {
  const input = document.getElementById('latexInput');
  const latexCode = input.value.trim();
  
  if (!latexCode) {
    alert('Please enter or select LaTeX code');
    return;
  }
  
  // Wrap in $$
  const equation = '$$' + latexCode + '$$';
  
  if (window.currentTextarea) {
    const start = window.currentTextarea.selectionStart;
    const end = window.currentTextarea.selectionEnd;
    const text = window.currentTextarea.value;
    
    window.currentTextarea.value = text.substring(0, start) + ' ' + equation + ' ' + text.substring(end);
    window.currentTextarea.focus();
    window.currentTextarea.dispatchEvent(new Event('input', { bubbles: true }));
  }
  
  // Close modal
  document.querySelector('[style*="position: fixed"][style*="z-index: 9999"]')?.remove();
}

// Backup insert functions for legacy template system
function insertMath(formula) {
  if (window.currentTextarea) {
    const start = window.currentTextarea.selectionStart;
    const end = window.currentTextarea.selectionEnd;
    const text = window.currentTextarea.value;
    
    window.currentTextarea.value = text.substring(0, start) + ' ' + formula + ' ' + text.substring(end);
    window.currentTextarea.focus();
    window.currentTextarea.dispatchEvent(new Event('input', { bubbles: true }));
  }
  document.body.querySelector('[style*="position: fixed"]')?.remove();
}

function insertCustomMath() {
  const customMath = document.getElementById('customMath')?.value;
  if (customMath?.trim()) {
    insertMath(customMath);
  }
}

function updateQuestionCount(){
  document.getElementById('questionCount').textContent = document.querySelectorAll('.question-card').length;
}

function updateTimeDisplay(){
  const mins = document.getElementById('timeLimit').value;
  document.getElementById('timeLimitDisplay').textContent = mins + ' min';
}

function addQuestion(){
  const wrap = document.createElement('div');
  wrap.className = 'question-card';
  wrap.style.cssText = 'padding: 1.5rem; background: white; border: 2px solid #e9ecef; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.08);';
  wrap.innerHTML = `
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem; padding-bottom: 1rem; border-bottom: 2px solid #e9ecef;">
      <h4 style="margin: 0; font-weight: 700; color: #333; font-size: 1rem;">
        <i class="bi bi-chat-left-text me-2" style="color: #4facfe;"></i>Question #${qIndex + 1}
      </h4>
      <button type="button" class="btn btn-sm" style="background: #fee; color: #dc3545; border: none; border-radius: 6px; padding: 0.5rem 0.75rem; font-weight: 600;" onclick="removeQuestion(this)">
        <i class="bi bi-trash"></i> Remove
      </button>
    </div>
    <div style="display: grid; grid-template-columns: 1fr auto; gap: 1.5rem; margin-bottom: 1.5rem;" class="grid-auto-fit">
      <div>
        <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333; font-size: 0.9rem;">Question Text</label>
        <div style="position: relative;">
          <textarea class="form-control question-text" name="questions[${qIndex}]" rows="3" placeholder="You can use LaTeX for math equations: $$E=mc^2$$" required style="border-radius: 8px; border: 2px solid #e9ecef; padding: 0.75rem; font-size: 1rem; font-family: monospace;"></textarea>
          <button type="button" class="btn btn-sm" style="position: absolute; top: 0.5rem; right: 0.5rem; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none; border-radius: 6px; padding: 0.4rem 0.75rem; font-weight: 600; font-size: 0.85rem;" onclick="showMathHelper(this)">
            <i class="bi bi-plus-lg me-1"></i>Add Math
          </button>
        </div>
        <small class="text-muted d-block mt-2">Use <strong>\\$\\$..\\$\\$</strong> for display equations or <strong>\\$...\\$</strong> for inline math (e.g., \\$\\$x = \\frac{-b \\pm \\sqrt{b^2-4ac}}{2a}\\$\\$)</small>
        <div class="math-preview" style="margin-top: 0.75rem; padding: 0.75rem; background: #f9f9f9; border-radius: 6px; border: 1px solid #e9ecef; min-height: 30px; display: block; line-height: 1.8; word-wrap: break-word; white-space: normal; overflow-wrap: break-word;"></div>
      </div>
      <div>
        <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333; font-size: 0.9rem;">Marks</label>
        <input type="number" class="form-control" name="marks[${qIndex}]" min="1" value="1" required style="border-radius: 8px; border: 2px solid #e9ecef; padding: 0.75rem; font-size: 1rem;">
      </div>
    </div>
    <div style="margin-bottom: 1.5rem; padding: 1rem; background: #f8f9fa; border-radius: 8px; border: 2px dashed #dee2e6;">
      <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333; font-size: 0.9rem;">
        <i class="bi bi-file-earmark-image me-1" style="color: #ffc107;"></i>Add Image or PDF (Optional)
      </label>
      <input type="file" class="form-control" name="question_images[${qIndex}]" accept="image/png,image/jpeg,image/gif,image/webp,application/pdf" style="border-radius: 6px; border: 1px solid #dee2e6; padding: 0.5rem; font-size: 0.9rem;">
      <small class="text-muted d-block mt-2">PNG, JPEG, GIF, WebP, or PDF (max 5MB)</small>
      <div id="img_preview_${qIndex}" style="margin-top: 1rem; display: none;">
        <img id="img_${qIndex}" style="max-width: 100%; max-height: 200px; border-radius: 6px; border: 1px solid #dee2e6;">
      </div>
    </div>
    <div>
      <label style="display: block; margin-bottom: 0.75rem; font-weight: 600; color: #333; font-size: 0.9rem;">
        <i class="bi bi-list-check me-1" style="color: #667eea;"></i>Options
      </label>
      <div id="opts_${qIndex}" style="display: flex; flex-direction: column; gap: 0.75rem;"></div>
      <button type="button" class="btn btn-sm" style="background: #e7f3ff; color: #4facfe; border: 2px solid #4facfe; margin-top: 1rem; border-radius: 6px; padding: 0.5rem 1rem; font-weight: 600;" onclick="addOption(${qIndex})">
        <i class="bi bi-plus me-1"></i>Add Option
      </button>
    </div>
    <div style="background: #fffbf0; border-left: 4px solid #ffc107; padding: 1rem; border-radius: 8px; margin-top: 1.5rem;">
      <p style="margin: 0; color: #ff9800; font-size: 0.9rem;">
        <i class="bi bi-exclamation-triangle-fill me-1"></i><strong>Important:</strong> Select the correct answer using the radio button, or students will see "N/A" in results!
      </p>
    </div>
  `;
  document.getElementById('questions').appendChild(wrap);
  
  // Add live math preview listener to textarea
  const textarea = wrap.querySelector('.question-text');
  const preview = wrap.querySelector('.math-preview');
  
  textarea.addEventListener('input', () => {
    if (textarea.value.includes('$')) {
      preview.innerHTML = textarea.value;
      preview.style.display = 'block';
      
      // Ensure all math elements display inline
      const mathElements = preview.querySelectorAll('mjx-container, .mjx-chtml');
      mathElements.forEach(el => {
        if (el.getAttribute('display') !== 'true') {
          el.style.display = 'inline';
          el.style.margin = '0 2px';
        }
      });
      
      // Re-render math in preview
      if (window.MathJax && window.MathJax.typesetPromise) {
        try {
          window.MathJax.typesetPromise([preview]).then(() => {
            // After typesetting, ensure inline display
            const mathElements = preview.querySelectorAll('mjx-container');
            mathElements.forEach(el => {
              if (!el.hasAttribute('display')) {
                el.style.display = 'inline';
                el.style.margin = '0 2px';
              }
            });
          }).catch(e => {});
        } catch(e) {}
      }
    } else {
      preview.style.display = 'none';
    }
  });
    }
  });
  
  addOption(qIndex);
  addOption(qIndex);
  qIndex++;
  updateQuestionCount();
}
function removeQuestion(btn){
  btn.closest('.question-card').remove();
  updateQuestionCount();
}
function addOption(i){
  const oWrap = document.getElementById('opts_' + i);
  const count = oWrap.querySelectorAll('input[type="text"]').length;
  const inputGroup = document.createElement('div');
  inputGroup.style.cssText = 'display: flex; gap: 0.5rem; align-items: center;';
  inputGroup.innerHTML = `
    <input type="radio" name="correct[${i}]" value="${count}" id="correct_${i}_${count}" style="width: 20px; height: 20px; cursor: pointer; margin-right: 0.5rem;">
    <input type="text" class="form-control" name="options[${i}][${count}]" placeholder="Option text" required style="border-radius: 6px; border: 2px solid #e9ecef; padding: 0.5rem; font-size: 0.9rem;">
    <button class="btn btn-sm" type="button" style="background: #fee; color: #dc3545; border: none; border-radius: 6px; padding: 0.5rem 0.75rem; font-weight: 600; white-space: nowrap;" onclick="this.closest('div').remove()">
      <i class="bi bi-x"></i> Remove
    </button>
  `;
  oWrap.appendChild(inputGroup);
}
document.addEventListener('DOMContentLoaded', () => {
  addQuestion();
  
  // Update time limit display on change
  document.getElementById('timeLimit').addEventListener('change', updateTimeDisplay);
  
  // Add event delegation for file inputs
  document.addEventListener('change', function(e) {
    if(e.target.name && e.target.name.startsWith('question_images')) {
      const file = e.target.files[0];
      if(file){
        const reader = new FileReader();
        const match = e.target.name.match(/\[(\d+)\]/);
        const index = match ? match[1] : null;
        if(index){
          reader.onload = function(event) {
            const preview = document.getElementById('img_preview_' + index);
            const img = document.getElementById('img_' + index);
            if(preview && img){
              img.src = event.target.result;
              preview.style.display = 'block';
            }
          };
          reader.readAsDataURL(file);
        }
      }
    }
  });

  // Add math preview update for question text
  document.addEventListener('input', function(e) {
    if (e.target.classList.contains('question-text')) {
      const preview = e.target.closest('div').querySelector('.math-preview');
      if (preview) {
        preview.innerHTML = e.target.value;
        preview.style.display = e.target.value.trim() ? 'block' : 'none';
        // Use KaTeX for rendering if available
        if (window.renderMathInElement) {
          try {
            window.renderMathInElement(preview, {
              delimiters: [
                {left: '$$', right: '$$', display: true},
                {left: '$', right: '$', display: false}
              ]
            });
          } catch(err) {
            console.log('KaTeX rendering:', err.message);
          }
        }
      }
    }
  });
  
  // Validate correct answers before submit
  document.getElementById('paperForm').addEventListener('submit', (e) => {
    const questions = document.querySelectorAll('.question-card');
    let hasError = false;
    
    questions.forEach((card, idx) => {
      const radioName = `correct[${idx}]`;
      const radios = document.querySelectorAll(`input[name="${radioName}"]`);
      const isChecked = Array.from(radios).some(r => r.checked);
      
      if (!isChecked && radios.length > 0) {
        hasError = true;
        const alertBox = card.querySelector('div[style*="background: #fffbf0"]');
        if (alertBox) {
          alertBox.style.background = '#fee';
          alertBox.style.borderColor = '#dc3545';
          alertBox.innerHTML = '<p style="margin: 0; color: #dc3545; font-size: 0.9rem;"><i class="bi bi-exclamation-triangle-fill me-1"></i><strong>ERROR:</strong> You must select which option is correct!</p>';
        }
      }
    });
    
    if (hasError) {
      e.preventDefault();
      alert('Please select the correct answer for all questions before submitting!');
      window.scrollTo({ top: 0, behavior: 'smooth' });
    }
  });
  
  // Trigger KaTeX rendering after page loads
  if (window.renderMathInElement) {
    try {
      window.renderMathInElement(document.body, {
        delimiters: [
          {left: '$$', right: '$$', display: true},
          {left: '$', right: '$', display: false},
          {left: '\\[', right: '\\]', display: true},
          {left: '\\(', right: '\\)', display: false}
        ]
      });
    } catch(err) {
      console.log('Initial KaTeX render:', err.message);
    }
  }
});
</script>
<?php render_footer(); ?>